﻿var licensing = {
    context: $(".v-licenses"),
    datatable: null,
    refreshPage: function () {
        window.location = window.location;
    },
    initializeDataTable: function () {
        this.datatable = $(".v-licensesTable", licensing.context).a4datatable({
            displaySearchBox: false,
            title: resources.InstalledLicenses,
            ajaxAction: a4.getAction("GetLicenses", "Licensing", "Admin"),
            columns: [
                { "Name": "Id", "Title": resources.Id },
                { "Name": "IssueDate", "Title": resources.IssueDate },
                { "Name": "InstallationDate", "Title": resources.InstallationDate },
                {
                    "Name": "Expiration", "Title": resources.ExpirationDate, "Data": "ExpirationDate", "DefaultValue": resources.NeverExpires,
                    "render": function (data) {
                        if (data && new Date(data) - new Date() < 30 * 24 * 60 * 60 * 1000 /* 30 days in milliseconds */) {
                            return `<span style="color: #F0345C; font-weight: 600">${data}</span>`;
                        }
                        return data;
                    }
                },
                { "Name": "Active", "Title": resources.Active, "Data": "Active", "Label": "ActiveLabel" }
            ],
            contextMenuItems: [
                { "Action": "details", "Label": resources.Details },
                { "Action": "copy", "Label": resources.Copy },
                { "Action": "deactivate", "Label": resources.Deactivate, "DisplayCondition": function (data) { return data.Active; } }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                if (action == "details") {
                    modalDialog.showWindow(a4.getAction("LicenseEditor", "Licensing", "Admin", { id: row.Id }), 600, 800, { afterClose: function () { licensing.refreshPage(); } });
                }
                else if (action == "copy") {
                    modalDialog.showWindow(a4.getAction("LicenseEditor", "Licensing", "Admin", { id: row.Id, isCopy: true }), 600, 800, { afterClose: function () { licensing.refreshPage(); } });
                }
                else if (action == "deactivate")
                    licensing.deactivateLicense(row.Id);
            },
            quickFilter: {
                "Items": [
                    { "Label": resources.Active, "AjaxParams": { "active": true } },
                    { "Label": resources.Inactive, "AjaxParams": { "active": false } }
                ]
            }
        });
    },

    bindEvents: function () {
        $(document).on("click", ".h-addLicense", function () {
            modalDialog.showWindow(a4.getAction("LicenseEditor", "Licensing", "Admin"), 600, 800, { afterClose: function () { licensing.refreshPage(); } });
        });

        $(document).on("click", ".h-editLimits", function () {
            modalDialog.showWindow(a4.getAction("LicenseLimitEditor", "Licensing", "Admin"), 600, 800, { afterClose: function () { licensing.refreshPage(); } });
        });
    },

    deactivateLicense: function (license) {
        modalDialog.showConfirmDialog(confirmDeactivateResources, function () {
            a4.callServerMethod(a4.getAction("DeactivateLicense", "Licensing", "Admin"), { id: license },
                function (result) {
                    licensing.refreshPage();
                });
        }, 250, 400, false, {});
    },
}

$(document).ready(function () {
    if (licensing.context.length > 0) {
        licensing.initializeDataTable();
        licensing.bindEvents();
    }
});


